import os
import re
import json

from pipelines.prompta.rag import OBJECT_BY_CATEGORY, META_DATA
from prompta.core.alphabet.events import EVENTS, is_event
from prompta.core.alphabet.verbs import VERBS


class MinecraftAlphabet:

    def __init__(self, skill_manager) -> None:
        self.skill_manager = skill_manager
        self.verbs = {_.identifier: _ for _ in VERBS}
        self.events = {_.identifier: _ for _ in EVENTS}
        self.skills = self.skill_manager.skills

        self.is_consistent = True
        
    def __contains__(self, symbol: str):
        if symbol in self.skills:
            return True
        for k, event in self.events.items():
            if event.accept(symbol):
                return self.events[k].accept(symbol)
        for k, verb in self.verbs.items():
            if verb.accept(symbol):
                return self.verbs[k].accept(symbol)
        return False
    
    def is_verb(self, symbol: str):
        for k, verb in self.verbs.items():
            if verb.accept(symbol):
                return self.verbs[k].accept(symbol)
        return False
    
    def is_event(self, symbol: str):
        for k, event in self.events.items():
            if event.accept(symbol):
                return self.events[k].accept(symbol)
        return False
    
    def is_skill(self, symbol: str):
        return symbol in self.skills
    
    def get_symbol_instance(self, symbol: str):
        if symbol in self.skills:
            return "skill", self.skills[symbol]
        for k, event in self.events.items():
            if event.accept(symbol):
                return "event", self.events[k]
        for k, verb in self.verbs.items():
            if verb.accept(symbol):
                return "verb", self.verbs[k]
        return "unknown", None
    
    def get_verb(self, symbol: str):
        for k, verb in self.verbs.items():
            if verb.accept(symbol):
                return self.verbs[k]
        raise KeyError(f"Unknown verb: {symbol}")
    
    def get_event(self, symbol: str):
        for k, event in self.events.items():
            if event.accept(symbol):
                return self.events[k]
        return None
        
